###################################################
### code chunk number : set your work directory
###################################################
## 
## Firstly, set your work directory to contain "main_loss_functions_others.R".
## Secondly, make sure there is a folder named "figure"
## in the same directory of "main_loss_functions_others.R".
##

###################################################
### code chunk number : Compare two loss functions
###################################################
## 
## Compare two loss functions:
## L_2(theta, a), L_s(theta, a)
## 
rm(list=ls(all=TRUE))

theta = 3
a = c(seq(1e-10, 3, by = 0.001), seq(3, 80, by = 1))
length(a)
y1 = (a - theta)^2 # L_2(theta, a)
y2 = a / theta - log(a / theta) - 1 # L_s(theta, a)

dev.new()
col = c("red", "blue")
lty = 1:2
ylim = c(0, 30) ## range(y1, y2)
plot(a, y1, type = "n", ylim = ylim, xlab = "a", ylab = expression( L(theta[n+1], a) ))
lines(a, y1, lty = lty[1], col = col[1], lwd = 4)
lines(a, y2, lty = lty[2], col = col[2], lwd = 4)
leg.txt = c(expression( L[2](theta[n+1], a) ), expression( L[s](theta[n+1], a) ))
legend("bottomright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = "figure/L_2_L_s", type = c("pdf"))
savePlot(filename = "figure/L_2_L_s", type = c("jpg"))


####################################################
### code chunk number : Simulations: 1 theta, not good
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 3     ## hyperparameter
beta = 2      ## hyperparameter
n = 1000      ## sample size

theta = 1 / rgamma(n = 1, shape = alpha, scale = 1/beta); theta
x = rexp(n = n, rate = 1/theta) ## the sample

#### Moment estimators
## Moment_estimators_EX_EX2_EX3_new() is the best
alpha_1_beta_1_EX_EX2 = Moment_estimators_EX_EX2(x); alpha_1_beta_1_EX_EX2


#### MLEs
p = alpha_1_beta_1_EX_EX2
alpha_2_beta_2 = Newtons(fun = moment_fun, y = p)$root; alpha_2_beta_2


####################################################
### code chunk number : Simulations: n theta, good
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
set.seed(1)
alpha = 3            ## hyperparameter
beta = 2             ## hyperparameter
n = 1000             ## sample size

theta = 1 / rgamma(n, shape = alpha, scale = 1/beta)
x = rexp(n = n, rate = 1/theta) ## the sample

#### Moment estimators
alpha_1_beta_1_EX_EX2 = Moment_estimators_EX_EX2(x); alpha_1_beta_1_EX_EX2

#### MLEs
p = alpha_1_beta_1_EX_EX2
alpha_2_beta_2 = Newtons(fun = moment_fun, y = p)$root; alpha_2_beta_2


